package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.clone.BreakBlockEntry;
import jamezo97.clonecraft.entity.clone.CloneOptions;
import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GuiSlotChooseBlocksToBreak extends GuiSlot{
	
	EntityClone clone;
	
	GuiChooseBlocksToBreak parent;
	
	private static RenderItem itemRenderer = new RenderItem();
	
	public GuiSlotChooseBlocksToBreak(EntityClone clone, GuiChooseBlocksToBreak parent){
		super(parent.getMc(), parent.width, parent.height, 32, parent.height-64, 36);
		this.clone = clone;
		this.parent = parent;
	}

	@Override
	protected int getSize() {
		return parent.visibleEntries.size();
	}

	@Override
	protected void elementClicked(int var1, boolean var2) {
		long merged = parent.visibleEntries.get(var1);
		if(!clone.options.removeBlockToBreak(merged)){
			clone.options.addBlockToBreak(merged);
			parent.onAdd(merged);
		}else{
			parent.onRemove(merged);
		}
	}

	@Override
	protected int getContentHeight() {
		return getSize() * slotHeight;
	}

	@Override
	protected boolean isSelected(int var1) {
		return clone.options.canBreakBlock(parent.visibleEntries.get(var1));
	}

	@Override
	protected void drawBackground() {
		parent.drawDefaultBackground();
	}

	@Override
	protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
		long merged = parent.visibleEntries.get(var1);
		parent.drawString(parent.getMc().fontRenderer, getBlockName(merged), var2, var3, 0xffffff);
		ItemStack stack = new ItemStack(getId(merged), 1, getMeta(merged));
		renderItem(stack, (var2 - 40)/2, var3/2);
		itemRenderer = new RenderItem();
	}
	
	public void renderItem(ItemStack var5, int par2, int par3){
		GL11.glPushMatrix();
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        RenderHelper.enableGUIStandardItemLighting();

        GL11.glScalef(2, 2, 2);
        
        itemRenderer.renderItemAndEffectIntoGUI(parent.getMc().fontRenderer, parent.getMc().renderEngine, var5, par2, par3);
	
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        GL11.glPopMatrix();
	}
	
	
	public static Block getBlock(long merged){
		int id = getId(merged);
		int meta = getMeta(merged);
		if(id > 0 && id < Block.blocksList.length){
			return Block.blocksList[id];
		}
		return null;
	}
	
	public static String getBlockName(long merged){
		int id = getId(merged);
		int meta = getMeta(merged);
		if(id > -1 && id < Block.blocksList.length){
			ItemStack stack = new ItemStack(id, 1, meta);
			return stack.getDisplayName();
		}
		return "\2474An unknown block?";
	}
	
	public static long merge(int id, int meta){
		long value = id;
		value |= ((long)meta) << 32;
		return value;
	}
	
	public static int getMeta(long merged){
		return (int)((merged >> 32) & 0xffffffff);
	}
	
	public static int getId(long merged){
		return (int)(merged & 0xffffffff);
	}

}
